--
-- simpleQuery.sql
--
DECLARE
  queryCtx DBMS_XMLquery.ctxType;
  result CLOB;
BEGIN
  -- set up the query context to select the first 20 rows of employees
  queryCtx := 
    DBMS_XMLQuery.newContext('SELECT * FROM employees WHERE rownum < 21');
 
  -- get the result
  result := DBMS_XMLQuery.getXML(queryCtx);
  -- Now you can use the result to put it in tables or send as messages
  printClobOut(result);
  DBMS_XMLQuery.closeContext(queryCtx);  -- you must close the query handle..
END;
/
